#ifndef _PORT_H
#define _PORT_H

/*******************************************************************************
*  (c) 2002, synertronixx GmbH
*  Vahrenwalder Str. 7
*  D-30165 Hannover
*  Tel. : 0511 / 93 57 670
*  Fax. : 0511 / 93 57 679
*  Web  : www.synertronixx.de
*  eMail: info@synertronixx.de
* ----------------------------
* Projekt       : DeviLAN
* Name          : port.h
* Version       : 1.04
* Datum         : 25.02.02
* Autor         : Borck, Blaschke
* *****************************************************************************/


/* PORTA_INPORT  :  PA0..PA7  inputs  */
/* PORTA_OUTPORT :  PA0..PA7  outputs */
/* PORTC1_INPORT :  PC0..PC3  inputs  */
/* PORTC1_OUTPORT:  PC0..PC3  outputs */
/* PORTC2_INPORT :  PC4..PC7  inputs  */
/* PORTC2_OUTPORT:  PC4..PC7  outputs */
typedef enum TPORTCONFIGURATION {PORTA_INPORT, PORTA_OUTPORT, PORTC1_INPORT, PORTC1_OUTPORT, PORTC2_INPORT, PORTC2_OUTPORT};

typedef enum TPEGEL {HIGH, LOW};


/* initialise 82C55 */
void Port8255Init(void);

/* 82C55 input/output select */
int PortConfiguration(int v_port_configuration);


/************************ P O R T A ************************/

/* Port A: write byte to port A */
void PortAByteOut(unsigned char byte);

/* Port A: set/reset single bit on port A */
int  PortABitOut(int v_nr, int v_pegel);

/* Port A: read port A input byte */
unsigned char PortAByteIn(void);


/************************ P O R T B ************************/

/* Port B: write byte to port b (7bits only)*/
void PortBByteOut(unsigned char byte);

/* Port B: set/reset single bit on port B (7bits only)*/
int  PortBBitOut(int v_nr, int v_pegel);


/************************ P O R T C ************************/

/* Port C: write byte to port C */
void PortCByteOut(unsigned char byte);

/* Port C: set/reset single bit on port C */
int  PortCBitOut(int v_nr, int v_pegel);

/* Port C: read port C input byte */
unsigned char PortCByteIn(void);


/************************ P O R T D ************************/
/* Port D: read port D input byte  (7bits only) */
unsigned char PortDByteIn(void);


#endif

// End of file port.h
