#ifndef ADC_H
#define ADC_H
/*******************************************************************************
*  (c) 2002, synertronixx GmbH
*  Vahrenwalder Str. 7
*  D-30165 Hannover
*  Tel. : 0511 / 93 57 670
*  Fax. : 0511 / 93 57 679
*  Web  : www.synertronixx.de
*  eMail: info@synertronixx.de
* ----------------------------
* Projekt       : DeviLAN
* Name          : adc.h
* Version       : 1.04
* Datum         : 25.02.02
* Autor         : Borck, Blaschke
* *****************************************************************************/

/*******************************************************************************
* Export: Definitions and Header
/******************************************************************************/

/* error flags AD-converter */
#define ADC_NOERROR            		 0x00
#define ADC_GAINOUTOFRANGE     		 0x01
#define ADC_CHANNELOUTOFRANGE  		 0x02
#define ADC_DATARATEOUTOFRANGE 		 0x04
#define ADC_DECRATIOOUTOFRANGE 		 0x08
#define ADC_ACKNOWLEDGEERROR   		 0x10

// AD-Converter

/* initialize AD-Converter SJA1000 */
void          ADCInit(void);

/* set parameter for converting */
unsigned char ADCSet(unsigned int adc_baudrate, unsigned char adc_channel, unsigned char adc_gain);

/* switch channel */
unsigned char ADCSelectChannel(unsigned char channel);

/* Start converting */
unsigned char ADCStartConvert(void);

/* Stop converting */
unsigned char ADCStopConvert(void);

/* ADC data avaiable ? */
unsigned char ADCValidData(void);

/* read data */
int           ADCRead(unsigned char* channel, long int* value);

// DA-Converter
#define DAC_NOERROR            		 0x00
#define DAC_CHANNELOUTOFRANGE  		 0x01
#define DAC_VALUEOUTOFRANGE     		 0x02

/* set value for DA-Converter */
unsigned char DACOut(unsigned char channel, unsigned int value);


#endif

// End of file adc.h
